/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.block.entity;

import io.github.foundationgames.automobility.automobile.attachment.front.AutopilotFrontAttachment;
import io.github.foundationgames.automobility.automobile.attachment.front.FrontAttachment;
import io.github.foundationgames.automobility.block.AutomobilityBlocks;
import io.github.foundationgames.automobility.block.AutopilotSignBlock;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AutopilotSignBlockEntity
extends BlockEntity {
    public static final int BROADCAST_INTERVAL = 4;
    private int broadcastDelay = 4;

    public AutopilotSignBlockEntity(BlockPos pos, BlockState blockState) {
        super(AutomobilityBlocks.AUTOPILOT_SIGN_ENTITY.require(), pos, blockState);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutopilotSignBlockEntity sign) {
        --sign.broadcastDelay;
        if (sign.broadcastDelay <= 0) {
            sign.broadcastDelay = 4;
            Block block = state.getBlock();
            if (block instanceof AutopilotSignBlock) {
                AutopilotSignBlock block2 = (AutopilotSignBlock)block;
                AABB box = new AABB(-16.0, -2.0, -16.0, 16.0, 2.0, 16.0);
                AutopilotSignBlock.Heading heading = block2.getHeading(state, pos);
                Vec3 boxOrigin = heading.planeOrigin().add(heading.limitPlane().scale(block2.getDetectBoxOffset(state)));
                box = box.move(boxOrigin);
                for (AutomobileEntity auto : level.getEntitiesOfClass(AutomobileEntity.class, box)) {
                    FrontAttachment fAtt = auto.getFrontAttachment();
                    if (!(fAtt instanceof AutopilotFrontAttachment)) continue;
                    AutopilotFrontAttachment autopilot = (AutopilotFrontAttachment)fAtt;
                    autopilot.notifyHeadingCommand(heading);
                }
            }
        }
    }
}

